<?php

/**
 * This is the model class for table "DziedzinaFirmy".
 *
 * The followings are the available columns in table 'DziedzinaFirmy':
 * @property double $id
 * @property double $idFirmy
 * @property double $idDziedziny
 * @property double $punkty
 */
class DziedzinaFirmy extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DziedzinaFirmy the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'DziedzinaFirmy';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idFirmy, idDziedziny', 'required'),
			array('idFirmy, idDziedziny, punkty', 'numerical'),

			array('id, idFirmy, idDziedziny, punkty', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'idFirmy0'=>array(self::BELONGS_TO, 'Firma', 'idFirmy'),
			'dziedzina'=>array(self::BELONGS_TO, 'Dziedzina', 'idDziedziny'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('DziedzinaFirmy', 'id'),
			'idFirmy'=>Yii::t('DziedzinaFirmy', 'idFirmy'),
			'idDziedziny'=>Yii::t('DziedzinaFirmy', 'idDziedziny'),
			'punkty'=>Yii::t('DziedzinaFirmy', 'punkty'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('idFirmy', $this->idFirmy);
		$criteria->compare('idDziedziny', $this->idDziedziny);
		$criteria->compare('punkty', $this->punkty);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public static function add($companyId, $dziedzinaId, $points)
	{
		$record = self::model()->findByAttributes(array(
			'idFirmy' => $companyId,
			'idDziedziny' => $dziedzinaId
		));
		if (empty($record))
		{
			$record = new DziedzinaFirmy;
			$record->idDziedziny = $dziedzinaId;
			$record->idFirmy = $companyId;
		}
		$record->punkty = (float)$record->punkty + $points;
		$record->save(false);
	}
}